IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CPJ_SCA_Clientes_Export]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[CPJ_SCA_Clientes_Export] 
END
GO

CREATE PROCEDURE [dbo].[CPJ_SCA_Clientes_Export] @pJsonRecibido VARCHAR(MAX)
AS 
SET NOCOUNT ON

IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CPJ_SCA_Clientes_Export_') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN 
	EXEC CPJ_SCA_Clientes_Export_ @pJsonRecibido
	RETURN
END	




DECLARE	@pSoc_Nro			VARCHAR(20),
		@pDoc_Nro			VARCHAR(20),
	    @pPasap_Nro			VARCHAR(50),
	    @pTag				VARCHAR(30),
		@pQR				VARCHAR(200),
		@pCateg				VARCHAR(5000),
	    @pMeses_Deuda		INT
	    
DECLARE	@query				VARCHAR(8000)


SET @pSoc_Nro				= ISNULL(CONVERT(VARCHAR(20), 	dbo.CF_JSON_VALUE(@pJsonRecibido,'Soc_Nro')),'')
SET @pDoc_Nro				= ISNULL(CONVERT(VARCHAR(20), 	dbo.CF_JSON_VALUE(@pJsonRecibido,'Doc_Nro')),'')
SET @pPasap_Nro				= ISNULL(CONVERT(VARCHAR(50), 	dbo.CF_JSON_VALUE(@pJsonRecibido,'Pasap_Nro')),'')
SET @pTag					= ISNULL(CONVERT(VARCHAR(30), 	dbo.CF_JSON_VALUE(@pJsonRecibido,'Tag')),'')
SET @pQR			        = ISNULL(CONVERT(VARCHAR(200), 	dbo.CF_JSON_VALUE(@pJsonRecibido,'QR')), '')
SET @pCateg			        = ISNULL(CONVERT(VARCHAR(5000), dbo.CF_JSON_VALUE(@pJsonRecibido,'Categ')), '')
SET @pMeses_Deuda			= ISNULL(CONVERT(INT,			dbo.CF_JSON_VALUE(@pJsonRecibido,'Meses_Deuda')), 0)

SET @query = 'SELECT
                       CL.Id_Cliente AS																Id_Persona
                      , RTRIM(CL.Id_Cliente_Externo) AS												Socio_Nro
					  , RTRIM(CL.Razon_Social) AS															Nombre 
					  , CL.Id_Tipo_Doc	AS															Id_Tipo_Doc
                      , ISNULL(CL.Doc_Nro,0) AS														Doc_Nro
                      , RTRIM(ISNULL(CL.Pasap_Nro,'''')) AS													Pasap_Nro
  					  , RTRIM(ISNULL(CL.Credencial_Nro,'''')) AS												Tag
					  , RTRIM(CONVERT(VARCHAR(50),CL.Doc_Nro)) AS											QR
					  , LTRIM(RTRIM(ISNULL(CL.Credencial_Banda1, ''''))) AS Credencial_Banda
					  , CL.Id_Tipo_Cli AS															Id_Categoria
					  , RTRIM(CT.Descripcion) AS															Categoria
					  , CONVERT(VARCHAR(10), (ISNULL(CL.Ult_Cuota_Paga,''19000101'')), 102) AS		Ult_Cuota_Paga
			FROM         Clientes CL, Clientes_Tipos CT
			WHERE CL.Id_Tipo_Cli = CT.Id_Tipo_Cli 
				AND CL.Activo = 1 
				AND CL.Id_Cliente > 1 '

IF @pCateg != ''
	SET @query += ' AND CL.Id_Tipo_Cli IN (' + @pCateg + ')'

IF @pQR != '' 
	IF ISNUMERIC(@pQR) = 1
		SET @query += ' AND CL.Doc_Nro = '+ @pQR
	ELSE
		SET @query += ' AND 1 = 0 '         --si paso un dato alfa no muestro evito error


IF @pSoc_Nro != ''
	SET @query += ' AND CL.Id_Cliente_Externo =''' + @pSoc_Nro + ''''

IF @pPasap_Nro != ''
	SET @query += ' AND CL.Pasap_Nro = '''+ @pPasap_Nro +''''

IF @pDoc_Nro != '' 
	IF ISNUMERIC(@pDoc_Nro) = 1
		SET @query += ' AND CL.Doc_Nro = '+ @pDoc_Nro
	ELSE
		SET @query += ' AND 1 = 0 '         --si paso un dato alfa no muestro evito error


IF @pPasap_Nro != ''
	SET @query += ' AND CL.Pasap_Nro = '''+ @pPasap_Nro +''''

IF @pTag != ''
	SET @query += ' AND CL.Credencial_Nro = '''+ @pTag +''''

IF @pMeses_Deuda != 0
	SET @query += ' AND DATEDIFF(mm,CL.Ult_Cuota_Paga,GETDATE()) < ' + CONVERT(VARCHAR(10),@pMeses_Deuda)


--PRINT @query

SET @query += ' ORDER BY 1'   

EXEC (@query)

RETURN
	

	/*

EXEC CPJ_SCA_Clientes_Export ''
EXEC CPJ_SCA_Clientes_Export '{"Categ":"4,33"}'
EXEC CPJ_SCA_Clientes_Export '{"Soc_Nro":"CAPM009637"}'
EXEC CPJ_SCA_Clientes_Export '{"Doc_Nro":"46585140"}'
EXEC CPJ_SCA_Clientes_Export '{"QR":"46585140"}'
EXEC CPJ_SCA_Clientes_Export '{"Pasap_Nro":"AAH032141"}'
EXEC CPJ_SCA_Clientes_Export '{"Doc_Nro":"2200876","Tag":"12713094"}'
EXEC CPJ_SCA_Clientes_Export '{"categ":"1,2,3,4,5,6,7,8,9,10,11,12"}'

	*/
	

